
package eu.de4a.iem.core.jaxb.common;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import eu.de4a.iem.core.jaxb.eidas.lp.LegalNameType;


/**
 * Legal Entity eIDAS mandatory dataset and optional dataset
 * 
 * &lt;p&gt;Java class for LegalPersonIdentifierType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="LegalPersonIdentifierType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="LegalPersonIdentifier" type="{http://eidas.europa.eu/attributes/legalperson}LegalPersonIdentifierType"/&amp;gt;
 *         &amp;lt;element name="LegalName" type="{http://eidas.europa.eu/attributes/legalperson}LegalNameType"/&amp;gt;
 *         &amp;lt;element name="LegalAddress" type="{http://eidas.europa.eu/attributes/legalperson}LegalPersonAddressType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="VATRegistration" type="{http://eidas.europa.eu/attributes/legalperson}VATRegistrationNumberType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="TaxReference" type="{http://eidas.europa.eu/attributes/legalperson}TaxReferenceType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="D-2012-17-EUIdentifier" type="{http://eidas.europa.eu/attributes/legalperson}D-2012-17-EUIdentifierType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="LEI" type="{http://eidas.europa.eu/attributes/legalperson}LEIType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="EORI" type="{http://eidas.europa.eu/attributes/legalperson}EORIType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="SEED" type="{http://eidas.europa.eu/attributes/legalperson}SEEDType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="SIC" type="{http://eidas.europa.eu/attributes/legalperson}SICType" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LegalPersonIdentifierType", propOrder = {
    "legalPersonIdentifier",
    "legalName",
    "legalAddress",
    "vatRegistration",
    "taxReference",
    "d201217EUIdentifier",
    "lei",
    "eori",
    "seed",
    "sic"
})
@CodingStyleguideUnaware
public class LegalPersonIdentifierType implements IExplicitlyCloneable
{

    @XmlElement(name = "LegalPersonIdentifier", required = true)
    private String legalPersonIdentifier;
    @XmlElement(name = "LegalName", required = true)
    private LegalNameType legalName;
    @XmlElement(name = "LegalAddress")
    private String legalAddress;
    @XmlElement(name = "VATRegistration")
    private String vatRegistration;
    @XmlElement(name = "TaxReference")
    private String taxReference;
    @XmlElement(name = "D-2012-17-EUIdentifier")
    private String d201217EUIdentifier;
    @XmlElement(name = "LEI")
    private String lei;
    @XmlElement(name = "EORI")
    private String eori;
    @XmlElement(name = "SEED")
    private String seed;
    @XmlElement(name = "SIC")
    private String sic;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public LegalPersonIdentifierType() {
    }

    /**
     * Gets the value of the legalPersonIdentifier property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getLegalPersonIdentifier() {
        return legalPersonIdentifier;
    }

    /**
     * Sets the value of the legalPersonIdentifier property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLegalPersonIdentifier(
        @Nullable
        String value) {
        this.legalPersonIdentifier = value;
    }

    /**
     * Gets the value of the legalName property.
     * 
     * @return
     *     possible object is
     *     {@link LegalNameType }
     *     
     */
    @Nullable
    public LegalNameType getLegalName() {
        return legalName;
    }

    /**
     * Sets the value of the legalName property.
     * 
     * @param value
     *     allowed object is
     *     {@link LegalNameType }
     *     
     */
    public void setLegalName(
        @Nullable
        LegalNameType value) {
        this.legalName = value;
    }

    /**
     * Gets the value of the legalAddress property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getLegalAddress() {
        return legalAddress;
    }

    /**
     * Sets the value of the legalAddress property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLegalAddress(
        @Nullable
        String value) {
        this.legalAddress = value;
    }

    /**
     * Gets the value of the vatRegistration property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getVATRegistration() {
        return vatRegistration;
    }

    /**
     * Sets the value of the vatRegistration property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVATRegistration(
        @Nullable
        String value) {
        this.vatRegistration = value;
    }

    /**
     * Gets the value of the taxReference property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getTaxReference() {
        return taxReference;
    }

    /**
     * Sets the value of the taxReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxReference(
        @Nullable
        String value) {
        this.taxReference = value;
    }

    /**
     * Gets the value of the d201217EUIdentifier property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getD201217EUIdentifier() {
        return d201217EUIdentifier;
    }

    /**
     * Sets the value of the d201217EUIdentifier property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setD201217EUIdentifier(
        @Nullable
        String value) {
        this.d201217EUIdentifier = value;
    }

    /**
     * Gets the value of the lei property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getLEI() {
        return lei;
    }

    /**
     * Sets the value of the lei property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLEI(
        @Nullable
        String value) {
        this.lei = value;
    }

    /**
     * Gets the value of the eori property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getEORI() {
        return eori;
    }

    /**
     * Sets the value of the eori property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEORI(
        @Nullable
        String value) {
        this.eori = value;
    }

    /**
     * Gets the value of the seed property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSEED() {
        return seed;
    }

    /**
     * Sets the value of the seed property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSEED(
        @Nullable
        String value) {
        this.seed = value;
    }

    /**
     * Gets the value of the sic property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSIC() {
        return sic;
    }

    /**
     * Sets the value of the sic property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSIC(
        @Nullable
        String value) {
        this.sic = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LegalPersonIdentifierType rhs = ((LegalPersonIdentifierType) o);
        if (!EqualsHelper.equals(d201217EUIdentifier, rhs.d201217EUIdentifier)) {
            return false;
        }
        if (!EqualsHelper.equals(eori, rhs.eori)) {
            return false;
        }
        if (!EqualsHelper.equals(legalAddress, rhs.legalAddress)) {
            return false;
        }
        if (!EqualsHelper.equals(legalName, rhs.legalName)) {
            return false;
        }
        if (!EqualsHelper.equals(legalPersonIdentifier, rhs.legalPersonIdentifier)) {
            return false;
        }
        if (!EqualsHelper.equals(lei, rhs.lei)) {
            return false;
        }
        if (!EqualsHelper.equals(seed, rhs.seed)) {
            return false;
        }
        if (!EqualsHelper.equals(sic, rhs.sic)) {
            return false;
        }
        if (!EqualsHelper.equals(taxReference, rhs.taxReference)) {
            return false;
        }
        if (!EqualsHelper.equals(vatRegistration, rhs.vatRegistration)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(d201217EUIdentifier).append(eori).append(legalAddress).append(legalName).append(legalPersonIdentifier).append(lei).append(seed).append(sic).append(taxReference).append(vatRegistration).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("d201217EUIdentifier", d201217EUIdentifier).append("eori", eori).append("legalAddress", legalAddress).append("legalName", legalName).append("legalPersonIdentifier", legalPersonIdentifier).append("lei", lei).append("seed", seed).append("sic", sic).append("taxReference", taxReference).append("vatRegistration", vatRegistration).getToString();
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        LegalPersonIdentifierType ret) {
        ret.d201217EUIdentifier = d201217EUIdentifier;
        ret.eori = eori;
        ret.legalAddress = legalAddress;
        ret.legalName = ((legalName == null)?null:legalName.clone());
        ret.legalPersonIdentifier = legalPersonIdentifier;
        ret.lei = lei;
        ret.seed = seed;
        ret.sic = sic;
        ret.taxReference = taxReference;
        ret.vatRegistration = vatRegistration;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LegalPersonIdentifierType clone() {
        LegalPersonIdentifierType ret = new LegalPersonIdentifierType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type LegalNameType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public LegalNameType setLegalName(
        @Nullable
        final String valueParam) {
        LegalNameType aObj = getLegalName();
        if (aObj == null) {
            aObj = new LegalNameType(valueParam);
            setLegalName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained LegalNameType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LegalNameType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getLegalNameValue() {
        LegalNameType aObj = getLegalName();
        return (aObj == null)?null:aObj.getValue();
    }

}
