/*
 * Decompiled with CFR 0.152.
 */
package eu.crydee.syllablecounter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SyllableCounter {
    private static final String exceptionsFilepath = "/eu/crydee/syllablecounter/english-exceptions.txt";
    private int maxCacheSize;
    private final Map<String, Integer> exceptions;
    private final Map<String, Integer> cache;
    private final List<Pattern> subSyl;
    private final List<Pattern> addSyl;
    private final Set<Character> vowels;

    public SyllableCounter() {
        this(0);
    }

    public SyllableCounter(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.cache = new HashMap<String, Integer>();
        this.exceptions = new HashMap<String, Integer>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(exceptionsFilepath)));){
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                String[] fields = line.split(" ");
                if (fields.length != 2) {
                    System.err.println("couldn't parse the exceptions file. Didn't find 2 fields in one of the lines.");
                }
                int nSyllables = Integer.parseInt(fields[0]);
                String word = fields[1];
                this.exceptions.put(word, nSyllables);
            }
        }
        catch (IOException ex) {
            System.err.println("couldn't open the exceptions file.");
            ex.printStackTrace(System.err);
        }
        this.subSyl = Arrays.asList("cial", "tia", "cius", "cious", "gui", "ion", "iou", "sia$", ".ely$").stream().map(Pattern::compile).collect(Collectors.toList());
        this.addSyl = Arrays.asList("ia", "riet", "dien", "iu", "io", "ii", "[aeiouy]bl$", "mbl$", "[aeiou]{3}", "^mc", "ism$", "(.)(?!\\1)([aeiouy])\\2l$", "[^l]llien", "^coad.", "^coag.", "^coal.", "^coax.", "(.)(?!\\1)[gq]ua(.)(?!\\2)[aeiou]", "dnt$").stream().map(Pattern::compile).collect(Collectors.toList());
        this.vowels = new HashSet<Character>();
        this.vowels.add(Character.valueOf('a'));
        this.vowels.add(Character.valueOf('e'));
        this.vowels.add(Character.valueOf('i'));
        this.vowels.add(Character.valueOf('o'));
        this.vowels.add(Character.valueOf('u'));
        this.vowels.add(Character.valueOf('y'));
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public int getCurrentCacheSize() {
        return this.cache.size();
    }

    public int count(String word) {
        if (word == null) {
            throw new NullPointerException("the word parameter was null.");
        }
        if (word.length() == 1) {
            return 1;
        }
        if (this.exceptions.containsKey(word = word.toLowerCase(Locale.ENGLISH))) {
            return this.exceptions.get(word);
        }
        if (this.maxCacheSize > 0 && this.cache.containsKey(word)) {
            return this.cache.get(word);
        }
        if (word.charAt(word.length() - 1) == 'e') {
            word = word.substring(0, word.length() - 1);
        }
        int count = 0;
        boolean prevIsVowel = false;
        for (char c : word.toCharArray()) {
            boolean isVowel = this.vowels.contains(Character.valueOf(c));
            if (isVowel && !prevIsVowel) {
                ++count;
            }
            prevIsVowel = isVowel;
        }
        Object object = this.addSyl.iterator();
        while (object.hasNext()) {
            Pattern pattern = (Pattern)object.next();
            if (!pattern.matcher(word).find()) continue;
            ++count;
        }
        for (Pattern pattern : this.subSyl) {
            if (!pattern.matcher(word).find()) continue;
            --count;
        }
        if (this.maxCacheSize > 0 && this.cache.size() < this.maxCacheSize) {
            this.cache.put(word, count);
        }
        return count;
    }
}

