/*
 * Decompiled with CFR 0.152.
 */
package eu.coldrye.junit.env;

import eu.coldrye.junit.env.EnvProvided;
import eu.coldrye.junit.env.EnvProvider;
import eu.coldrye.junit.util.ReflectionUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.platform.commons.util.Preconditions;

class ParameterResolverImpl {
    ParameterResolverImpl() {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext, List<EnvProvider> providers) {
        Preconditions.notNull((Object)parameterContext, (String)"parameterContext must not be null");
        Preconditions.notNull(providers, (String)"providers must not be null");
        Parameter parameter = parameterContext.getParameter();
        if (ReflectionUtils.isAnnotatedBy((AnnotatedElement)parameter, (Class[])new Class[]{EnvProvided.class})) {
            for (EnvProvider provider : providers) {
                if (!provider.canProvideInstance(parameter, parameter.getType())) continue;
                return true;
            }
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext, List<EnvProvider> providers) {
        Preconditions.notNull((Object)parameterContext, (String)"parameterContext must not be null");
        Preconditions.notNull(providers, (String)"providers must not be null");
        Parameter parameter = parameterContext.getParameter();
        for (EnvProvider provider : providers) {
            if (!provider.canProvideInstance(parameter, parameter.getType())) continue;
            return provider.getOrCreateInstance(parameter, parameter.getType());
        }
        throw new ParameterResolutionException("unable to resolve parameter " + parameter.toString());
    }
}

