/*
 * Decompiled with CFR 0.152.
 */
package eu.coldrye.junit.env;

import eu.coldrye.junit.env.EnvProvider;
import eu.coldrye.junit.env.Environment;
import eu.coldrye.junit.env.Environments;
import eu.coldrye.junit.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.platform.commons.util.Preconditions;

class EnvProviderCollector {
    EnvProviderCollector() {
    }

    List<Class<? extends EnvProvider>> collect(Class<?> clazz) {
        Preconditions.notNull(clazz, (String)"clazz must not be null");
        ArrayList<Class<? extends EnvProvider>> result = new ArrayList<Class<? extends EnvProvider>>();
        List annotations = ReflectionUtils.getAllAnnotations(clazz, (Class[])new Class[]{Environments.class, Environment.class});
        for (Annotation annotation : annotations) {
            if (annotation instanceof Environment) {
                Environment environment = (Environment)annotation;
                this.collect0(environment.value(), result);
                continue;
            }
            Environments environments = (Environments)annotation;
            for (Environment environment : environments.value()) {
                this.collect0(environment.value(), result);
            }
        }
        return result;
    }

    private void collect0(Class<? extends EnvProvider> providerClass, List<Class<? extends EnvProvider>> collectedProviderClasses) {
        if (!(collectedProviderClasses.contains(providerClass) || providerClass.isInterface() || Modifier.isAbstract(providerClass.getModifiers()))) {
            collectedProviderClasses.add(providerClass);
        }
    }
}

