/*
 * Decompiled with CFR 0.152.
 */
package eu.coldrye.junit.env;

import eu.coldrye.junit.env.EnvPhase;
import eu.coldrye.junit.env.EnvProviderManager;
import eu.coldrye.junit.env.FieldInjector;
import eu.coldrye.junit.env.ParameterResolverImpl;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.util.Preconditions;

public final class EnvExtension
implements TestInstancePostProcessor,
ParameterResolver,
BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private final EnvProviderManager providerManager;
    private final FieldInjector fieldInjector;
    private final ParameterResolverImpl parameterResolver;

    public EnvExtension() {
        this(EnvProviderManager.getInstance(), new FieldInjector(), new ParameterResolverImpl());
    }

    EnvExtension(EnvProviderManager providerManager, FieldInjector fieldInjector, ParameterResolverImpl parameterResolver) {
        Preconditions.notNull((Object)providerManager, (String)"providerManager must not be null");
        Preconditions.notNull((Object)fieldInjector, (String)"fieldInjector must not be null");
        Preconditions.notNull((Object)parameterResolver, (String)"parameterResolver must not be null");
        this.providerManager = providerManager;
        this.fieldInjector = fieldInjector;
        this.parameterResolver = parameterResolver;
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        if (!this.providerManager.isPrepared(context)) {
            this.providerManager.prepareEnvironmentProviders(context);
            this.providerManager.setUpEnvironments(EnvPhase.INIT, context);
        }
        this.fieldInjector.inject(testInstance, context, this.providerManager.getProviders(context, EnvPhase.PREPARE));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.parameterResolver.supportsParameter(parameterContext, extensionContext, this.providerManager.getProviders(extensionContext, EnvPhase.PREPARE));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.parameterResolver.resolveParameter(parameterContext, extensionContext, this.providerManager.getProviders(extensionContext, EnvPhase.PREPARE));
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.providerManager.setUpEnvironments(EnvPhase.BEFORE_EACH, context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.providerManager.tearDownEnvironments(EnvPhase.AFTER_EACH, context);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        Preconditions.notNull(context.getTestClass().orElse(null), (String)"EnvExtension can only be used on ElementType.TYPE");
        if (!this.providerManager.isPrepared(context)) {
            this.providerManager.prepareEnvironmentProviders(context);
            this.providerManager.setUpEnvironments(EnvPhase.INIT, context);
        }
        this.providerManager.setUpEnvironments(EnvPhase.BEFORE_ALL, context);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (!this.providerManager.isPrepared(context)) {
            this.providerManager.prepareEnvironmentProviders(context);
        }
        this.providerManager.tearDownEnvironments(EnvPhase.AFTER_ALL, context);
    }
}

