/*
 * Decompiled with CFR 0.152.
 */
package eu.coldrye.junit.env;

import eu.coldrye.junit.ReflectionHelper;
import eu.coldrye.junit.env.EnvProvided;
import eu.coldrye.junit.env.EnvProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;

class FieldInjector {
    FieldInjector() {
    }

    public void inject(Object testInstance, ExtensionContext context, List<EnvProvider> providers) throws Exception {
        Assertions.assertNotNull((Object)testInstance, (String)"testInstance must not be null");
        Assertions.assertNotNull(providers, (String)"providers must not be null");
        List fields = ReflectionHelper.getDeclaredFields(testInstance.getClass(), (Class[])new Class[]{EnvProvided.class});
        block0: for (Field field : fields) {
            for (EnvProvider provider : providers) {
                if (!provider.canProvideInstance(field, field.getType())) continue;
                this.inject0(testInstance, field, provider);
                continue block0;
            }
        }
    }

    private void inject0(Object testInstance, Field field, EnvProvider provider) throws Exception {
        Object instance = provider.getOrCreateInstance(field, field.getType());
        Method setter = ReflectionHelper.findMethod(testInstance.getClass(), (String)ReflectionHelper.setterName((Field)field), (Class[])new Class[]{field.getType()});
        if (Objects.isNull(setter)) {
            field.setAccessible(true);
            field.set(testInstance, instance);
        } else {
            setter.setAccessible(true);
            setter.invoke(testInstance, instance);
        }
    }
}

