/*
 * Decompiled with CFR 0.152.
 */
package eu.coldrye.junit.env;

import eu.coldrye.junit.env.EnvPhase;
import eu.coldrye.junit.env.EnvProvider;
import eu.coldrye.junit.env.EnvProviderCollector;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnvProviderManager {
    static final ThreadLocal<EnvProviderManager> INSTANCE = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(EnvProviderManager.class);
    private final EnvProviderCollector collector;
    private Map<Class<?>, List<EnvProvider>> preparedProviders = new HashMap();

    EnvProviderManager(EnvProviderCollector collector) {
        Preconditions.notNull((Object)collector, (String)"collector must not be null");
        Preconditions.condition((boolean)Objects.isNull(INSTANCE.get()), (String)"must not be instantiated more than once per thread");
        this.collector = collector;
    }

    static EnvProviderManager getInstance() {
        return EnvProviderManager.getInstance(new EnvProviderCollector());
    }

    static EnvProviderManager getInstance(EnvProviderCollector collector) {
        if (Objects.isNull(INSTANCE.get())) {
            INSTANCE.set(new EnvProviderManager(collector));
        }
        return INSTANCE.get();
    }

    static void destroyInstance() {
        INSTANCE.set(null);
    }

    List<EnvProvider> getProviders(ExtensionContext context, EnvPhase phase) {
        Preconditions.notNull((Object)context, (String)"context must not be null");
        Preconditions.notNull((Object)((Object)phase), (String)"phase must not be null");
        Preconditions.condition((boolean)this.isPrepared(context), (String)("Illegal state: environment providers have not yet been prepared during phase " + (Object)((Object)phase)));
        return this.preparedProviders.get(context.getRequiredTestClass());
    }

    void prepareEnvironmentProviders(ExtensionContext context) throws Exception {
        Preconditions.notNull((Object)context, (String)"context must not be null");
        if (this.isPrepared(context)) {
            return;
        }
        ArrayList<EnvProvider> providers = new ArrayList<EnvProvider>();
        Class testClass = context.getRequiredTestClass();
        List<Class<? extends EnvProvider>> providerClasses = this.collector.collect(testClass);
        for (Class<? extends EnvProvider> providerClass : providerClasses) {
            EnvProvider provider = providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ExtensionContext.Namespace ns = ExtensionContext.Namespace.create((Object[])new Object[]{providerClass.getName(), Thread.currentThread().getId()});
            ExtensionContext.Store store = context.getStore(ns);
            provider.setStore(store);
            providers.add(provider);
        }
        this.preparedProviders.put(testClass, providers);
    }

    void shutdown() {
        if (this.preparedProviders.isEmpty()) {
            return;
        }
        for (Map.Entry<Class<?>, List<EnvProvider>> entry : this.preparedProviders.entrySet()) {
            try {
                for (EnvProvider provider : entry.getValue()) {
                    provider.tearDownEnvironment(EnvPhase.DEINIT, entry.getKey());
                }
            }
            catch (Exception ex) {
                log.error("There was an error during shutdown ", (Throwable)ex);
            }
            entry.setValue(null);
        }
        this.preparedProviders.clear();
    }

    void setUpEnvironments(EnvPhase phase, ExtensionContext context) throws Exception {
        for (EnvProvider provider : this.getProviders(context, phase)) {
            provider.setUpEnvironment(phase, (AnnotatedElement)context.getElement().orElseThrow(new IllegalState()));
        }
    }

    void tearDownEnvironments(EnvPhase phase, ExtensionContext context) throws Exception {
        for (EnvProvider provider : this.getProviders(context, phase)) {
            provider.tearDownEnvironment(phase, (AnnotatedElement)context.getElement().orElseThrow(new IllegalState()));
        }
    }

    boolean isPrepared(ExtensionContext context) {
        return !Objects.isNull(this.preparedProviders.getOrDefault(context.getRequiredTestClass(), null));
    }

    class IllegalState
    implements Supplier<IllegalStateException> {
        IllegalState() {
        }

        @Override
        public IllegalStateException get() {
            return new IllegalStateException("context did not provide the required annotated element");
        }
    }
}

