package eu.codlab.lorcana.resources

import dev.icerock.moko.graphics.Color
import dev.icerock.moko.resources.AssetResource
import dev.icerock.moko.resources.ColorResource
import dev.icerock.moko.resources.FileResource
import dev.icerock.moko.resources.FontResource
import dev.icerock.moko.resources.ImageResource
import dev.icerock.moko.resources.PluralsResource
import dev.icerock.moko.resources.ResourceContainer
import dev.icerock.moko.resources.StringResource
import kotlin.String
import kotlin.collections.List

public actual object Resources {
  private val contentHash: String = "97d9b49e4f1f403d223a0f4dbba36a65"

  public actual object strings : ResourceContainer<StringResource> {
    public override fun values(): List<StringResource> = listOf()
  }

  public actual object plurals : ResourceContainer<PluralsResource> {
    public override fun values(): List<PluralsResource> = listOf()
  }

  public actual object images : ResourceContainer<ImageResource> {
    public override fun values(): List<ImageResource> = listOf()
  }

  public actual object fonts : ResourceContainer<FontResource> {
    public override fun values(): List<FontResource> = listOf()
  }

  public actual object files : ResourceContainer<FileResource> {
    public actual val abilities: FileResource = FileResource(fileUrl =
        js("require(\"files/abilities.json\")") as String)

    public actual val d23: FileResource = FileResource(fileUrl = js("require(\"files/d23.json\")")
        as String)

    public actual val franchises: FileResource = FileResource(fileUrl =
        js("require(\"files/franchises.json\")") as String)

    public actual val placeholders: FileResource = FileResource(fileUrl =
        js("require(\"files/placeholders.json\")") as String)

    public actual val tfc: FileResource = FileResource(fileUrl = js("require(\"files/tfc.json\")")
        as String)

    public override fun values(): List<FileResource> = listOf(abilities, d23, franchises,
        placeholders, tfc)
  }

  public actual object colors : ResourceContainer<ColorResource> {
    public override fun values(): List<ColorResource> = listOf()
  }

  public actual object assets : ResourceContainer<AssetResource> {
    public override fun values(): List<AssetResource> = listOf()
  }
}
