package eu.codlab.lorcana.resources

import dev.icerock.moko.graphics.Color
import dev.icerock.moko.resources.AssetResource
import dev.icerock.moko.resources.ColorResource
import dev.icerock.moko.resources.FileResource
import dev.icerock.moko.resources.FontResource
import dev.icerock.moko.resources.ImageResource
import dev.icerock.moko.resources.PluralsResource
import dev.icerock.moko.resources.ResourceContainer
import dev.icerock.moko.resources.StringResource
import dev.icerock.moko.resources.utils.loadableBundle
import kotlin.String
import platform.Foundation.NSBundle

public actual object Resources {
  private val bundle: NSBundle by lazy { NSBundle.loadableBundle("eu.codlab.lorcana.resources.MR") }

  private val contentHash: String = "debd8415be200e58061d223360678d3b"

  public actual object strings : ResourceContainer<StringResource> {
    public override val nsBundle: NSBundle = bundle
  }

  public actual object plurals : ResourceContainer<PluralsResource> {
    public override val nsBundle: NSBundle = bundle
  }

  public actual object images : ResourceContainer<ImageResource> {
    public override val nsBundle: NSBundle = bundle
  }

  public actual object fonts : ResourceContainer<FontResource> {
    public override val nsBundle: NSBundle = bundle
  }

  public actual object files : ResourceContainer<FileResource> {
    public actual val abilities: FileResource = FileResource(fileName = "abilities", extension =
        "yml",bundle = bundle)

    public actual val classifications: FileResource = FileResource(fileName = "classifications",
        extension = "yml",bundle = bundle)

    public actual val configuration: FileResource = FileResource(fileName = "configuration",
        extension = "yml",bundle = bundle)

    public actual val franchises: FileResource = FileResource(fileName = "franchises", extension =
        "yml",bundle = bundle)

    public actual val iti: FileResource = FileResource(fileName = "iti", extension = "yml",bundle =
        bundle)

    public actual val placeholders: FileResource = FileResource(fileName = "placeholders", extension
        = "yml",bundle = bundle)

    public actual val rotf: FileResource = FileResource(fileName = "rotf", extension = "yml",bundle
        = bundle)

    public actual val tfc: FileResource = FileResource(fileName = "tfc", extension = "yml",bundle =
        bundle)

    public actual val urr: FileResource = FileResource(fileName = "urr", extension = "yml",bundle =
        bundle)

    public override val nsBundle: NSBundle = bundle
  }

  public actual object colors : ResourceContainer<ColorResource> {
    public override val nsBundle: NSBundle = bundle
  }

  public actual object assets : ResourceContainer<AssetResource> {
    public override val nsBundle: NSBundle = bundle
  }
}
