package eu.codlab.lorcana.resources

import dev.icerock.moko.graphics.Color
import dev.icerock.moko.resources.AssetResource
import dev.icerock.moko.resources.ColorResource
import dev.icerock.moko.resources.FileResource
import dev.icerock.moko.resources.FontResource
import dev.icerock.moko.resources.ImageResource
import dev.icerock.moko.resources.PluralsResource
import dev.icerock.moko.resources.ResourceContainer
import dev.icerock.moko.resources.StringResource
import dev.icerock.moko.resources.utils.loadableBundle
import kotlin.String
import platform.Foundation.NSBundle

public actual object Resources {
  private val bundle: NSBundle by lazy { NSBundle.loadableBundle("eu.codlab.lorcana.resources.MR") }

  private val contentHash: String = "0fdc8973993734c3725e1c87e8fe30b5"

  public actual object strings : ResourceContainer<StringResource> {
    public override val nsBundle: NSBundle = bundle
  }

  public actual object plurals : ResourceContainer<PluralsResource> {
    public override val nsBundle: NSBundle = bundle
  }

  public actual object images : ResourceContainer<ImageResource> {
    public override val nsBundle: NSBundle = bundle
  }

  public actual object fonts : ResourceContainer<FontResource> {
    public override val nsBundle: NSBundle = bundle
  }

  public actual object files : ResourceContainer<FileResource> {
    public actual val abilities: FileResource = FileResource(fileName = "abilities", extension =
        "json",bundle = bundle)

    public actual val d23: FileResource = FileResource(fileName = "d23", extension = "json",bundle =
        bundle)

    public actual val franchises: FileResource = FileResource(fileName = "franchises", extension =
        "json",bundle = bundle)

    public actual val placeholders: FileResource = FileResource(fileName = "placeholders", extension
        = "json",bundle = bundle)

    public actual val rotf: FileResource = FileResource(fileName = "rotf", extension = "json",bundle
        = bundle)

    public actual val tfc: FileResource = FileResource(fileName = "tfc", extension = "json",bundle =
        bundle)

    public override val nsBundle: NSBundle = bundle
  }

  public actual object colors : ResourceContainer<ColorResource> {
    public override val nsBundle: NSBundle = bundle
  }

  public actual object assets : ResourceContainer<AssetResource> {
    public override val nsBundle: NSBundle = bundle
  }
}
