package eu.codlab.lorcana.resources

import dev.icerock.moko.resources.FileResource
import dev.icerock.moko.resources.ResourceContainer
import dev.icerock.moko.resources.ResourcePlatformDetails
import dev.icerock.moko.resources.utils.loadableBundle
import kotlin.String
import kotlin.collections.List
import platform.Foundation.NSBundle

public actual object Resources {
  private val contentHash: String = "e5d5f5e2d53d44a04d375d1bdf07960d"

  private val bundle: NSBundle by lazy { NSBundle.loadableBundle("eu.codlab.lorcana.resources.main")
      }

  public actual object files : ResourceContainer<FileResource> {
    public actual override val __platformDetails: ResourcePlatformDetails =
        ResourcePlatformDetails(bundle)

    public actual val classifications_yml: FileResource = FileResource(fileName = "classifications",
        extension = "yml", bundle = __platformDetails.nsBundle)

    public actual val iti_yml: FileResource = FileResource(fileName = "iti", extension = "yml",
        bundle = __platformDetails.nsBundle)

    public actual val placeholders_yml: FileResource = FileResource(fileName = "placeholders",
        extension = "yml", bundle = __platformDetails.nsBundle)

    public actual val ssk_yml: FileResource = FileResource(fileName = "ssk", extension = "yml",
        bundle = __platformDetails.nsBundle)

    public actual val urr_yml: FileResource = FileResource(fileName = "urr", extension = "yml",
        bundle = __platformDetails.nsBundle)

    public actual val abilities_yml: FileResource = FileResource(fileName = "abilities", extension =
        "yml", bundle = __platformDetails.nsBundle)

    public actual val rotf_yml: FileResource = FileResource(fileName = "rotf", extension = "yml",
        bundle = __platformDetails.nsBundle)

    public actual val azu_yml: FileResource = FileResource(fileName = "azu", extension = "yml",
        bundle = __platformDetails.nsBundle)

    public actual val franchises_yml: FileResource = FileResource(fileName = "franchises", extension
        = "yml", bundle = __platformDetails.nsBundle)

    public actual val configuration_yml: FileResource = FileResource(fileName = "configuration",
        extension = "yml", bundle = __platformDetails.nsBundle)

    public actual val tfc_yml: FileResource = FileResource(fileName = "tfc", extension = "yml",
        bundle = __platformDetails.nsBundle)

    public actual override fun values(): List<FileResource> = listOf(classifications_yml, iti_yml,
        placeholders_yml, ssk_yml, urr_yml, abilities_yml, rotf_yml, azu_yml, franchises_yml,
        configuration_yml, tfc_yml)
  }
}
