package eu.codlab.lorcana.resources

import dev.icerock.moko.graphics.Color
import dev.icerock.moko.resources.AssetResource
import dev.icerock.moko.resources.ColorResource
import dev.icerock.moko.resources.FileResource
import dev.icerock.moko.resources.FontResource
import dev.icerock.moko.resources.ImageResource
import dev.icerock.moko.resources.PluralsResource
import dev.icerock.moko.resources.ResourceContainer
import dev.icerock.moko.resources.StringResource
import eu.codlab.lorcana.R

public actual object Resources {
  public actual object strings : ResourceContainer<StringResource>

  public actual object plurals : ResourceContainer<PluralsResource>

  public actual object images : ResourceContainer<ImageResource>

  public actual object fonts : ResourceContainer<FontResource>

  public actual object files : ResourceContainer<FileResource> {
    public actual val abilities: FileResource = FileResource(rawResId = R.raw.abilities)

    public actual val configuration: FileResource = FileResource(rawResId = R.raw.configuration)

    public actual val franchises: FileResource = FileResource(rawResId = R.raw.franchises)

    public actual val iti: FileResource = FileResource(rawResId = R.raw.iti)

    public actual val placeholders: FileResource = FileResource(rawResId = R.raw.placeholders)

    public actual val rotf: FileResource = FileResource(rawResId = R.raw.rotf)

    public actual val tfc: FileResource = FileResource(rawResId = R.raw.tfc)
  }

  public actual object colors : ResourceContainer<ColorResource>

  public actual object assets : ResourceContainer<AssetResource>
}
