package eu.codlab.compose.widgets.spacers

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.WindowInsets
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.statusBars
import androidx.compose.material3.HorizontalDivider
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.platform.LocalDensity
import androidx.compose.ui.unit.dp
import eu.codlab.compose.utils.isCompatibleForSpacers

/**
 * Quick implementation pushing down given the current status bar
 */
@Composable
fun TopSpacer(color: Color = Color.Transparent) {
    if (!isCompatibleForSpacers()) {
        return
    }

    val height = WindowInsets.statusBars.getTop(LocalDensity.current)
    val scaled = height / LocalDensity.current.density

    HorizontalDivider(
        thickness = 0.dp,
        modifier = Modifier
            .background(color = color)
            .height(scaled.dp)
    )
}
