package eu.codlab.compose.widgets.spacers

import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.WindowInsets
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.navigationBars
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalDensity
import androidx.compose.ui.unit.dp
import eu.codlab.compose.utils.isCompatibleForSpacers

/**
 * Quick implementation pushing down given the current navigation bar
 */
@Composable
fun BottomSpacer() {
    if (!isCompatibleForSpacers()) {
        return
    }

    val height = WindowInsets.navigationBars.getTop(LocalDensity.current)
    val scaled = height / LocalDensity.current.density

    Spacer(
        modifier = Modifier.height(scaled.dp)
    )
}
