package eu.codlab.compose.widgets

import androidx.compose.desktop.ui.tooling.preview.Preview
import eu.codlab.compose.preview.PreviewAppMaterialTheme
import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.interaction.MutableInteractionSource
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.RowScope
import androidx.compose.material3.ButtonColors
import androidx.compose.material3.ButtonDefaults
import androidx.compose.material3.ButtonElevation
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.OutlinedButton
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Shape
import androidx.compose.ui.unit.dp

@Suppress("LongParameterList")
@Composable
fun CustomOutlinedButton(
    onClick: () -> Unit,
    modifier: Modifier = Modifier,
    enabled: Boolean = true,
    interactionSource: MutableInteractionSource = remember { MutableInteractionSource() },
    elevation: ButtonElevation? = null,
    shape: Shape = MaterialTheme.shapes.small,
    border: BorderStroke? = BorderStroke(
        0.dp, // was ButtonDefaults.OutlinedBorderSize,
        MaterialTheme.colorScheme.primary
    ),
    colors: ButtonColors = ButtonDefaults.outlinedButtonColors(
        contentColor = MaterialTheme.colorScheme.onSurface
    ),
    contentPadding: PaddingValues = ButtonDefaults.ContentPadding,
    content: @Composable RowScope.() -> Unit
) = OutlinedButton(
    onClick = onClick,
    modifier = modifier,
    enabled = enabled,
    interactionSource = interactionSource,
    elevation = elevation,
    shape = shape,
    border = border,
    colors = colors,
    contentPadding = contentPadding,
    content = content
)

@Preview
@Composable
private fun CustomOutLinedButtonPreviewDark() =
    PreviewAppMaterialTheme(darkTheme = true) {
        CustomOutlinedButton(
            onClick = { },
            content = {
                TextNormal(text = "button ")
            }
        )
    }

@Preview
@Composable
private fun CustomOutLinedButtonPreviewLight() =
    PreviewAppMaterialTheme(darkTheme = false) {
        CustomOutlinedButton(
            onClick = { },
            content = {
                TextNormal(text = "button ")
            }
        )
    }
