package eu.codlab.compose.widgets.preview

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.ColumnScope
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.RowScope
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color

data class Configuration(
    val background: Color
)

data class PreviewDarkLightConfiguration(
    val light: Configuration,
    val dark: Configuration
)

private val defaultConfiguration = PreviewDarkLightConfiguration(
    light = Configuration(
        background = Color.White
    ),
    dark = Configuration(
        background = Color.Black
    )
)

@Composable
fun PreviewDarkLightColumn(
    configuration: PreviewDarkLightConfiguration = defaultConfiguration,
    modifier: Modifier = Modifier,
    submodifier: ColumnScope.() -> Modifier = { Modifier },
    repeatableContent: @Composable ColumnScope.(modifier: Modifier, isDark: Boolean) -> Unit
) = Column(modifier = modifier) {
    listOf(
        false to configuration.light,
        true to configuration.dark
    ).forEach { (isDark, configuration) ->
        repeatableContent(
            submodifier().weight(1f).background(configuration.background),
            isDark
        )
    }
}

@Composable
fun PreviewDarkLightRow(
    configuration: PreviewDarkLightConfiguration = defaultConfiguration,
    modifier: Modifier = Modifier,
    submodifier: RowScope.() -> Modifier = { Modifier },
    repeatableContent: @Composable RowScope.(modifier: Modifier, isDark: Boolean) -> Unit
) = Row(modifier = modifier) {
    listOf(
        false to configuration.light,
        true to configuration.dark
    ).forEach { (isDark, configuration) ->
        repeatableContent(
            submodifier().weight(1f).background(configuration.background),
            isDark
        )
    }
}
