package eu.codlab.compose.theme

import androidx.compose.foundation.isSystemInDarkTheme
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.CompositionLocalProvider
import androidx.compose.runtime.DisposableEffect
import androidx.compose.runtime.compositionLocalOf
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue

val LocalDarkTheme = compositionLocalOf { false }
val LocalThemeEnvironment = compositionLocalOf {
    ThemeEnvironment()
}

@Suppress("MagicNumber")
@Composable
fun AppMaterialTheme(
    darkTheme: Boolean = isSystemInDarkTheme(),
    darkEnvironment: ThemeEnvironment,
    lightEnvironment: ThemeEnvironment,
    content: @Composable () -> Unit
) {
    val currentTheme = LocalDarkTheme.current
    val currentLocalThemeEnvironment = LocalThemeEnvironment.current

    var isDarkTheme by remember { mutableStateOf(currentTheme) }
    var selectedLocalThemeEnvironment by remember { mutableStateOf(currentLocalThemeEnvironment) }

    DisposableEffect(darkTheme) {
        isDarkTheme = darkTheme
        selectedLocalThemeEnvironment = if (isDarkTheme) {
            darkEnvironment
        } else {
            lightEnvironment
        }

        onDispose {
            // nothing
        }
    }

    val material = if (darkTheme) {
        darkEnvironment.material
    } else {
        lightEnvironment.material
    }

    CompositionLocalProvider(
        LocalDarkTheme provides isDarkTheme,
        LocalThemeEnvironment provides selectedLocalThemeEnvironment
    ) {
        if (null == material) {
            MaterialTheme {
                content()
            }
        } else {
            MaterialTheme(
                colorScheme = material.colors,
                typography = material.typography,
                shapes = material.shapes
            ) {
                content()
            }
        }
    }
}
