package androidx.compose.desktop.ui.tooling.preview.eu.codlab.compose.preview

import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color
import eu.codlab.compose.theme.AppColor
import eu.codlab.compose.theme.AppMaterialTheme
import eu.codlab.compose.theme.ColorBottomNavigations
import eu.codlab.compose.theme.ColorTheme
import eu.codlab.compose.theme.ThemeEnvironment

private val fullBlack = Color(0xff000000)
private val unselected = Color(0xff7a6b63)
private val selected = Color(0xffeec788)

internal val EnvironmentDark = ThemeEnvironment(
    navigationColors = ColorBottomNavigations(
        background = fullBlack,
        unselected = unselected,
        selected = selected
    ),
    colors = ColorTheme(
        graySemiTransparent = AppColor.GraySemiTransparentLight
    ),
    gradientStart = AppColor.Violet,
    gradientEnd = AppColor.Blue
)

internal val EnvironmentLight = ThemeEnvironment(
    navigationColors = ColorBottomNavigations(
        background = fullBlack,
        unselected = unselected,
        selected = selected
    ),
    colors = ColorTheme(
        graySemiTransparent = AppColor.GraySemiTransparentDark
    ),
    gradientStart = Color.White,
    gradientEnd = AppColor.BlueLighter
)

@Composable
internal fun PreviewAppMaterialTheme(darkTheme: Boolean, content: @Composable () -> Unit) {
    AppMaterialTheme(
        darkTheme = darkTheme,
        darkEnvironment = EnvironmentDark,
        lightEnvironment = EnvironmentLight,
        content = content
    )
}
