package eu.codlab.compose.widgets

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.RowScope
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.size
import androidx.compose.material3.Button
import androidx.compose.material3.CircularProgressIndicator
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp

@Composable
fun LoadingButton(
    modifier: Modifier = Modifier,
    isLoading: Boolean,
    onClick: () -> Unit,
    content: @Composable RowScope.() -> Unit
) {
    Button(
        modifier = modifier,
        enabled = !isLoading,
        onClick = onClick
    ) {
        LoadingButtonContent(isLoading, content)
    }
}

@Composable
fun OutlinedLoadingButton(
    modifier: Modifier = Modifier,
    enabled: Boolean = true,
    isLoading: Boolean,
    onClick: () -> Unit,
    content: @Composable RowScope.() -> Unit = {}
) {
    CustomOutlinedButton(
        modifier = modifier,
        enabled = !isLoading && enabled,
        onClick = onClick
    ) {
        LoadingButtonContent(isLoading, content)
    }
}

@Composable
private fun RowScope.LoadingButtonContent(
    isLoading: Boolean,
    content: @Composable (RowScope.() -> Unit)
) {
    if (isLoading) {
        CircularProgressIndicator(modifier = Modifier.size(25.dp))
    } else {
        content()
    }
}
