package eu.codlab.compose.widgets

import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.WindowInsets
import androidx.compose.foundation.layout.height
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalDensity
import androidx.compose.ui.unit.dp
import eu.codlab.safearea.views.bottomBar

@Composable
actual fun BottomSpacer() {
    val height = WindowInsets.bottomBar.getBottom(LocalDensity.current)
    val scaled = height / LocalDensity.current.density

    println("BottomSpacer is set to $height -> $scaled")
    Spacer(
        modifier = Modifier
            .height(scaled.dp)
    )
}
