package eu.codlab.compose.widgets

import androidx.compose.foundation.layout.Column
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.MoreVert
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import eu.codlab.compose.theme.PreviewAppMaterialTheme

@Preview
@Composable
private fun RenderTextDark() {
    PreviewAppMaterialTheme(darkTheme = true) {
        Column(modifier = Modifier.systemBackground()) {
            TextTitle(text = "title")
            TextSubtitle(text = "subtitle")
            TextNormal(text = "text")
            VectorIcon(imageVector = Icons.Default.MoreVert)
        }
    }
}

@Preview
@Composable
private fun RenderTextLight() {
    PreviewAppMaterialTheme(darkTheme = false) {
        Column(modifier = Modifier.systemBackground()) {
            TextTitle(text = "title")
            TextSubtitle(text = "subtitle")
            TextNormal(text = "text")

            VectorIcon(imageVector = Icons.Default.MoreVert)
        }
    }
}
