package eu.codlab.compose.widgets

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import eu.codlab.compose.theme.PreviewAppMaterialTheme

@Composable
private fun LoadingButtonPreview() {
    val modifier = Modifier.fillMaxWidth()
    Column {
        LoadingButton(
            modifier = modifier,
            isLoading = true,
            onClick = {},
            content = { Text("Loading button") })
        LoadingButton(
            modifier = modifier,
            isLoading = false,
            onClick = {},
            content = { Text("Loading button") })

        OutlinedLoadingButton(
            modifier = modifier,
            isLoading = true,
            onClick = {},
            content = { Text("Outlined loading button") })
        OutlinedLoadingButton(
            modifier = modifier,
            isLoading = false,
            onClick = {},
            content = { Text("Outlined loading button") })
    }
}

@Preview(widthDp = 250)
@Composable
private fun LoadingButtonPreviewDark() =
    PreviewAppMaterialTheme(darkTheme = true) { LoadingButtonPreview() }

@Preview(widthDp = 250)
@Composable
private fun LoadingButtonPreviewLight() =
    PreviewAppMaterialTheme(darkTheme = false) { LoadingButtonPreview() }
