package eu.codlab.compose.theme

import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color

private val fullBlack = Color(0xff000000)
private val unselected = Color(0xff7a6b63)
private val selected = Color(0xffeec788)

val EnvironmentDark = ThemeEnvironment(
    navigationColors = ColorBottomNavigations(
        background = fullBlack,
        unselected = unselected,
        selected = selected
    ),
    colors = ColorTheme(
        graySemiTransparent = AppColor.GraySemiTransparentLight
    ),
    gradientStart = AppColor.Violet,
    gradientEnd = AppColor.Blue
)

val EnvironmentLight = ThemeEnvironment(
    navigationColors = ColorBottomNavigations(
        background = fullBlack,
        unselected = unselected,
        selected = selected
    ),
    colors = ColorTheme(
        graySemiTransparent = AppColor.GraySemiTransparentDark
    ),
    gradientStart = Color.White,
    gradientEnd = AppColor.BlueLighter
)

@Composable
fun PreviewAppMaterialTheme(darkTheme: Boolean, content: @Composable () -> Unit) {
    AppMaterialTheme(
        darkTheme = darkTheme,
        darkEnvironment = EnvironmentDark,
        lightEnvironment = EnvironmentLight,
        content = content
    )
}
