package eu.codlab.compose.widgets

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Menu
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import eu.codlab.compose.theme.PreviewAppMaterialTheme

@Composable
private fun TransparentButtonPreview() {
    val modifier = Modifier.fillMaxWidth()
    Column(
        modifier = Modifier.systemBackground()
    ) {
        TransparentIconButton(
            modifier = modifier,
            onClick = {},
            imageVector = Icons.Default.Menu
        )
    }
}

@Preview(widthDp = 250)
@Composable
private fun TransparentButtonPreviewDark() =
    PreviewAppMaterialTheme(darkTheme = true) { TransparentButtonPreview() }

@Preview(widthDp = 250)
@Composable
private fun TransparentButtonPreviewLight() =
    PreviewAppMaterialTheme(darkTheme = false) { TransparentButtonPreview() }
