package eu.codlab.compose.theme

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.material3.Divider
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp

@Preview(widthDp = 250)
@Composable
private fun PreviewColors() {
    Column {
        listOf(
            AppColor.Violet,
            AppColor.VioletLight,
            AppColor.VioletLighter,
            AppColor.VioletEvenLighter,
            AppColor.Blue,
            AppColor.BlueLight,
            AppColor.Pink,
            AppColor.PinkLight,
            AppColor.Black,
            AppColor.GrayExtraDark,
            AppColor.GrayDark,
            AppColor.Gray,
            AppColor.GrayLight,
            AppColor.GrayExtraLight,
            AppColor.Black10,
            AppColor.Black05,
            AppColor.Red,
            AppColor.BackgroundBlue
        ).map {
            Divider(
                modifier = Modifier
                    .fillMaxWidth()
                    .height(2.dp)
                    .background(
                        color = it
                    )
            )
        }
    }
}
