package eu.codlab.compose.widgets

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.text.KeyboardOptions
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.input.KeyboardType
import androidx.compose.ui.text.input.TextFieldValue
import androidx.compose.ui.tooling.preview.Preview
import eu.codlab.compose.theme.PreviewAppMaterialTheme

@Preview(widthDp = 250)
@Composable
private fun CustomOutLinedButtonPreviewDark() =
    PreviewAppMaterialTheme(darkTheme = true) {
        ShowPreview()
    }

@Preview(widthDp = 250)
@Composable
private fun CustomOutLinedButtonPreviewLight() =
    PreviewAppMaterialTheme(darkTheme = false) {
        ShowPreview()
    }

@Composable
private fun ShowPreview() = Column(
    modifier = Modifier.systemBackground()
) {
    CustomOutlinedEditText(
        value = TextFieldValue("Default value"),
        onValueChanged = { value -> println(value) }
    )
    CustomOutlinedEditText(
        keyboardOptions = KeyboardOptions(keyboardType = KeyboardType.Password),
        value = TextFieldValue("Password"),
        onValueChanged = { value -> println(value) }
    )
}
