package eu.codlab.weather.common.models

import kotlinx.serialization.Serializable

@Suppress("MagicNumber")
@Serializable
enum class WeatherConditionMap(
    val code: Int,
    val isAlert: Boolean = false,
    val alertType: WeatherConditionAlertType? = null
) {
    ThunderstormWithHeavyRain(202, true, WeatherConditionAlertType.Thunderstorm),
    ThunderstormWithLightRain(200, true, WeatherConditionAlertType.Thunderstorm),
    ThunderstormWithRain(201, true, WeatherConditionAlertType.Thunderstorm),
    ThunderstormLight(210, true, WeatherConditionAlertType.Thunderstorm),
    Thunderstorm(211, true, WeatherConditionAlertType.Thunderstorm),
    ThunderstormHeavy(212, true, WeatherConditionAlertType.Thunderstorm),
    ThunderstormRagged(221, true, WeatherConditionAlertType.Thunderstorm),
    ThunderstormWithLightDrizzle(230, true, WeatherConditionAlertType.Thunderstorm),
    ThunderstormWithDrizzle(231, true, WeatherConditionAlertType.Thunderstorm),
    ThunderstormWithHeavyDrizzle(232, true, WeatherConditionAlertType.Thunderstorm),
    DrizzleHeavyIntensity(302, true, WeatherConditionAlertType.Drizzle),
    DrizzleHeavyShowerRain(314),
    DrizzleHeavyIntensityRain(312),
    DrizzleLightIntensity(300),
    DrizzleLightIntensityRain(310),
    DrizzleShowerRain(313),
    DrizzleRain(311),
    DrizzleShower(321),
    Drizzle(301),
    RainFreezing(511, true, WeatherConditionAlertType.Rain),
    RainExtreme(504, true, WeatherConditionAlertType.Rain),
    RainHeavyIntensity(502),
    RainVeryHeavy(503),
    RainModerate(501),
    RainShower(521),
    RainLightIntensityShower(520),
    RainLight(500),
    RainHeavyIntensityShower(522),
    RainRaggedShower(531),
    SnowHeavyShower(622, true, WeatherConditionAlertType.Snow),
    SnowShower(621, true, WeatherConditionAlertType.Snow),
    SnowHeavy(602, true, WeatherConditionAlertType.Snow),
    SnowLight(600),
    SnowSleet(611),
    Snow(601),
    SnowSleetLightShower(612),
    SnowShowerSleet(613),
    SnowAndLightRain(615),
    SnowAndRain(616),
    SnowLightShower(620),
    Mist(701, true, WeatherConditionAlertType.Mist),
    Smoke(711, true, WeatherConditionAlertType.Smoke),
    Haze(721, true, WeatherConditionAlertType.Haze),
    DustSandWhirls(731, true, WeatherConditionAlertType.Sandstorm),
    Fog(741, true, WeatherConditionAlertType.Fog),
    Sand(751, true, WeatherConditionAlertType.Sandstorm),
    Dust(761, true, WeatherConditionAlertType.Dust),
    Ash(762, true, WeatherConditionAlertType.Ash),
    Squall(771, true, WeatherConditionAlertType.Squall),
    Tornado(781, true, WeatherConditionAlertType.Tornado),
    Clear(800),
    CloudsFew(801),
    CloudsScattered(802),
    CloudsBroken(803),
    CloudsOvercast(804);

    companion object {
        fun fromCode(code: Int) = WeatherConditionMap.entries
            .find { it.code == code }
    }
}
