package eu.codlab.viewpager.pagination

import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp

/**
 * Simple pager indicator
 *
 * Source : https://medium.com/@domen.lanisnik/exploring-the-official-pager-in-compose-8c2698c49a98
 */
@Composable
fun HorizontalDotPagerIndicator(
    pageCount: Int,
    currentPage: Int,
    targetPage: Int,
    currentPageOffsetFraction: Float,
    modifier: Modifier = Modifier,
    indicatorColor: Color = Color.DarkGray,
    unselectedIndicatorSize: Dp = 8.dp,
    selectedIndicatorSize: Dp = 10.dp,
    indicatorPadding: Dp = 2.dp
) = HorizontalDotPagerIndicatorWrapper(
    pageCount,
    currentPage,
    targetPage,
    currentPageOffsetFraction,
    modifier,
    indicatorColor,
    unselectedIndicatorSize,
    selectedIndicatorSize,
    indicatorPadding
)