package eu.codlab.viewpager.pagination

import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp

/**
 * Simple pager indicator
 *
 * Source : https://medium.com/@domen.lanisnik/exploring-the-official-pager-in-compose-8c2698c49a98
 */
@Composable
fun HorizontalPagerIndicator(
    pageCount: Int,
    currentPage: Int,
    targetPage: Int,
    currentPageOffsetFraction: Float,
    modifier: Modifier = Modifier,
    indicatorColor: Color = Color.DarkGray,
    unselectedIndicatorSize: Dp = 8.dp,
    selectedIndicatorSize: Dp = 10.dp,
    indicatorCornerRadius: Dp = 2.dp,
    indicatorPadding: Dp = 2.dp,
    limit: Int = Int.MAX_VALUE
) = HorizontalDotPagerIndicatorWrapper(
    pageCount,
    currentPage,
    targetPage,
    currentPageOffsetFraction,
    modifier,
    indicatorColor,
    unselectedIndicatorSize,
    selectedIndicatorSize,
    indicatorPadding,
    limit
) { size ->
    MorphedSize(
        padding = DpRectangle(
            width = ((selectedIndicatorSize + indicatorPadding * 2) - size) / 2,
            height = size / 4
        ),
        cornerSize = indicatorCornerRadius,
        indicator = DpRectangle(
            width = size,
            height = size / 2
        )
    )
}
