package eu.codlab.viewmodel.samples

import androidx.compose.foundation.layout.Column
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.runtime.rememberCoroutineScope
import eu.codlab.viewmodel.effects.ActionsEffect
import eu.codlab.viewmodel.StateActionsViewModel
import eu.codlab.viewmodel.launch
import eu.codlab.viewmodel.rememberViewModel
import kotlinx.coroutines.delay
import kotlin.time.Duration.Companion.seconds

@Composable
fun RememberViewModelSample() {
    val model = rememberViewModel { ViewModelSample() }
    val state by model.states.collectAsState()
    val coroutineScope = rememberCoroutineScope()

    ActionsEffect(model, coroutineScope) {
        println(it)
    }

    /**
     *
     * private data class State(
     *     val someInt: Int = 0,
     * )
     *
     * private sealed class Actions {
     *     object NavigateToSettings : Actions()
     *     object NavigateBack : Actions()
     * }
     *
     * private class ViewModelSample : StateActionsViewModel<State, Actions>(State()) {
     *     // your logic
     * }
     */

    Column {
        // nothing
    }
}

private data class State(
    val someInt: Int = 0,
)

private sealed class Actions {
    object NavigateToSettings : Actions()
    object NavigateBack : Actions()
}

private class ViewModelSample : StateActionsViewModel<State, Actions>(State()) {
    fun someComputation() = launch {
        delay(5.seconds)
        updateState {
            copy(
                someInt = someInt + 1
            )
        }
    }
}