package eu.codlab.viewmodel.effects

import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.runtime.rememberCoroutineScope
import androidx.compose.ui.platform.LocalLifecycleOwner
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.repeatOnLifecycle
import eu.codlab.viewmodel.ActionsHandler
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

@Composable
fun <UiAction> ActionsEffect(
    actionsHandler: ActionsHandler<UiAction>,
    coroutineScope: CoroutineScope = rememberCoroutineScope(),
    handler: suspend (UiAction) -> Unit
) {
    val lifecycleOwner = LocalLifecycleOwner.current

    DisposableEffect(Unit) {
        val job = coroutineScope.launch {
            lifecycleOwner.lifecycle.repeatOnLifecycle(Lifecycle.State.STARTED) {
                actionsHandler.actions.collect { handler(it) }
            }
        }
        onDispose { job.cancel() }
    }
}