package eu.codlab.safearea.theme

import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import eu.codlab.safearea.views.SystemBarsBehavior

internal typealias OriginalBehavior = com.moriatsushi.insetsx.SystemBarsBehavior

@Composable
actual fun rememberWindowInsetsController(): WindowInsetsController? {
    val value = com.moriatsushi.insetsx.rememberWindowInsetsController() ?: return null

    return remember {
        object : WindowInsetsController {
            override fun setIsNavigationBarsVisible(isVisible: Boolean) =
                    value.setIsNavigationBarsVisible(isVisible)

            override fun setIsStatusBarsVisible(isVisible: Boolean) =
                    value.setIsStatusBarsVisible(isVisible)

            override fun setNavigationBarsContentColor(dark: Boolean) =
                    value.setNavigationBarsContentColor(dark)

            override fun setStatusBarContentColor(dark: Boolean) =
                    value.setStatusBarContentColor(dark)

            override fun setSystemBarsBehavior(behavior: SystemBarsBehavior) =
                    value.setSystemBarsBehavior(
                            when (behavior) {
                                SystemBarsBehavior.Default -> OriginalBehavior.Default
                                SystemBarsBehavior.Immersive -> OriginalBehavior.Default
                            }
                    )

        }
    }
}
