package eu.codlab.safearea.views

enum class SystemBarsBehavior {
    /**
     * Default option to to remain interactive when hiding system bars.
     *
     * * In Android: The system bars can be revealed with system gestures,
     * such as swiping from the edge.
     * * In iOS: The system bar can be revealed temporarily with system gestures,
     * but disappears after a period of time.
     */
    Default,

    /**
     * An immersive mode that limits user interaction when system bars are hidden.
     * The system bar can be revealed temporarily with system gestures,
     * but disappears after a period of time.
     */
    Immersive
}
