package eu.codlab.safearea.samples

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.navigationBarsPadding
import androidx.compose.foundation.layout.statusBarsPadding
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.ui.Modifier
import eu.codlab.safearea.theme.rememberWindowInsetsController

@Composable
internal fun WindowsInsetsView() {
    val controller = rememberWindowInsetsController()

    LaunchedEffect(controller) {
        controller?.apply {
            // the 2 method to manage the status & navigation bars
            setIsStatusBarsVisible(false)
            setIsNavigationBarsVisible(false)

            // the 2 ones which control which color will be used
            setStatusBarContentColor(dark = true)
            setNavigationBarsContentColor(dark = true)
        }
    }

    Column(
        modifier = Modifier
            .navigationBarsPadding()
            .statusBarsPadding()
    ) {
        // some views
    }
}
