/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.ui.tooling.preview

import android.annotation.SuppressLint
import androidx.annotation.IntDef


/** Constant for [.uiMode]: bits that encode the mode type.  */
const val UI_MODE_TYPE_MASK = 0x0f

/** Constant for [.uiMode]: a [.UI_MODE_TYPE_MASK]
 * value indicating that no mode type has been set.  */
const val UI_MODE_TYPE_UNDEFINED = 0x00

/** Constant for [.uiMode]: a [.UI_MODE_TYPE_MASK]
 * value that corresponds to
 * [no
 * UI mode]({@docRoot}guide/topics/resources/providing-resources.html#UiModeQualifier) resource qualifier specified.  */
const val UI_MODE_TYPE_NORMAL = 0x01

/** Constant for [.uiMode]: a [.UI_MODE_TYPE_MASK]
 * value that corresponds to the
 * [desk]({@docRoot}guide/topics/resources/providing-resources.html#UiModeQualifier)
 * resource qualifier.  */
const val UI_MODE_TYPE_DESK = 0x02

/** Constant for [.uiMode]: a [.UI_MODE_TYPE_MASK]
 * value that corresponds to the
 * [car]({@docRoot}guide/topics/resources/providing-resources.html#UiModeQualifier)
 * resource qualifier.  */
const val UI_MODE_TYPE_CAR = 0x03

/** Constant for [.uiMode]: a [.UI_MODE_TYPE_MASK]
 * value that corresponds to the
 * [television]({@docRoot}guide/topics/resources/providing-resources.html#UiModeQualifier)
 * resource qualifier.  */
const val UI_MODE_TYPE_TELEVISION = 0x04

/** Constant for [.uiMode]: a [.UI_MODE_TYPE_MASK]
 * value that corresponds to the
 * [appliance]({@docRoot}guide/topics/resources/providing-resources.html#UiModeQualifier)
 * resource qualifier.  */
const val UI_MODE_TYPE_APPLIANCE = 0x05

/** Constant for [.uiMode]: a [.UI_MODE_TYPE_MASK]
 * value that corresponds to the
 * [watch]({@docRoot}guide/topics/resources/providing-resources.html#UiModeQualifier)
 * resource qualifier.  */
const val UI_MODE_TYPE_WATCH = 0x06

/** Constant for [.uiMode]: a [.UI_MODE_TYPE_MASK]
 * value that corresponds to the
 * [vrheadset]({@docRoot}guide/topics/resources/providing-resources.html#UiModeQualifier)
 * resource qualifier.  */
const val UI_MODE_TYPE_VR_HEADSET = 0x07

/** Constant for [.uiMode]: bits that encode the night mode.  */
const val UI_MODE_NIGHT_MASK = 0x30

/** Constant for [.uiMode]: a [.UI_MODE_NIGHT_MASK]
 * value indicating that no mode type has been set.  */
const val UI_MODE_NIGHT_UNDEFINED = 0x00

/** Constant for [.uiMode]: a [.UI_MODE_NIGHT_MASK]
 * value that corresponds to the
 * [notnight]({@docRoot}guide/topics/resources/providing-resources.html#NightQualifier)
 * resource qualifier.  */
const val UI_MODE_NIGHT_NO = 0x10

/** Constant for [.uiMode]: a [.UI_MODE_NIGHT_MASK]
 * value that corresponds to the
 * [night]({@docRoot}guide/topics/resources/providing-resources.html#NightQualifier)
 * resource qualifier.  */
const val UI_MODE_NIGHT_YES = 0x20

/**
 * Annotation of setting uiMode in [Preview].
 * @hide
 */
@SuppressLint("UniqueConstants") // UI_MODE_NIGHT_UNDEFINED == UI_MODE_TYPE_UNDEFINED
@Retention(AnnotationRetention.SOURCE)
@IntDef(
    value = [
        UI_MODE_TYPE_MASK,
        UI_MODE_TYPE_UNDEFINED,
        UI_MODE_TYPE_APPLIANCE,
        UI_MODE_TYPE_CAR,
        UI_MODE_TYPE_DESK,
        UI_MODE_TYPE_NORMAL,
        UI_MODE_TYPE_TELEVISION,
        UI_MODE_TYPE_VR_HEADSET,
        UI_MODE_TYPE_WATCH,
        UI_MODE_NIGHT_MASK,
        UI_MODE_NIGHT_UNDEFINED,
        UI_MODE_NIGHT_NO,
        UI_MODE_NIGHT_YES
    ]
)
annotation class UiMode
