package eu.codlab.openweathermap.rest

import kotlinx.serialization.Serializable

@Serializable
data class RestOptions(
    val apiKey: String,
    val apiLimit: Int = 300,
    val timeout: Long = 30000,
    val units: String = "meters",
    val rejectUnauthorized: Boolean = true,
    val log: (tag: String, text: String) -> Unit = { _, _ -> }
)
