package eu.codlab.openweathermap.models.api3

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class Hourly(
    val dt: Long,
    @SerialName("temp")
    val temperature: Float,
    @SerialName("feels_like")
    val feelsLike: Float,
    val humidity: Int,
    @SerialName("dew_point")
    val dewPoint: Float,
    val uvi: Int,
    val clouds: Int,
    val visibility: Int,
    @SerialName("wind_speed")
    val windSpeed: Float,
    @SerialName("wind_deg")
    val windDeg: Int,
    @SerialName("wind_gust")
    val windGust: Float,
    val precipitation: Int,
    val rain: RaindSnow? = null,
    val snow: RaindSnow? = null,
    val weather: List<Weather>,
    val pop: Float,
    // alerts TBD
)
