package eu.codlab.openweathermap.models.api3

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class Current(
    val dt: Long,
    val sunrise: Long = 0,
    val sunset: Long = 0,
    @SerialName("temp")
    val temperature: Float,
    @SerialName("feels_like")
    val feelsLike: Float,
    val pressure: Int,
    val humidity: Int,
    @SerialName("dew_point")
    val dewPoint: Float,
    val uvi: Int,
    val clouds: Int,
    val visibility: Int,
    @SerialName("wind_speed")
    val windSpeed: Float,
    @SerialName("wind_deg")
    val windDeg: Int,
    @SerialName("wind_gust")
    val windGust: Float,
    val precipitation: Int,
    val rain: RainOrSnow? = null,
    val snow: RainOrSnow? = null,
    val weather: List<Weather>,
    // alerts TBD
)
