package eu.codlab.openweathermap

import eu.codlab.openweathermap.calls.RestApiPublic
import eu.codlab.openweathermap.rest.RestOptions

class Api2(
    apiKey: String,
    units: String,
    enableHttpLogs: Boolean = false
) {
    private val call = RestApiPublic(
        RestOptions(
            apiKey = apiKey,
            units = units,
            enableHttpLogs = enableHttpLogs
        )
    )

    suspend fun forecastWeatherForCity(cityName: String) = call.forecast4days(
        mapOf("q" to cityName)
    )

    suspend fun forecastWeatherForCityId(cityId: String) = call.forecast4days(
        mapOf("id" to cityId)
    )

    suspend fun forecastWeatherForPosition(latitude: Double, longitude: Double) =
        call.forecast4days(
            mapOf(
                "lat" to "$latitude",
                "lon" to "$longitude"
            )
        )

    suspend fun currentWeatherForCity(cityName: String) = call.weather(
        mapOf("q" to cityName)
    )

    suspend fun currentWeatherForCityId(cityId: String) = call.weather(
        mapOf("id" to cityId)
    )

    suspend fun currentWeatherForPosition(latitude: Double, longitude: Double) = call.weather(
        mapOf(
            "lat" to "$latitude",
            "lon" to "$longitude"
        )
    )
}
