package eu.codlab.openweathermap.models.api2

import eu.codlab.weather.common.models.Coord
import kotlinx.serialization.Serializable

@Serializable
data class WeatherData(
    val coord: Coord,
    val weather: List<WeatherCondition>,
    val base: String,
    val main: MainInformation,
    val wind: Wind,
    val rain: Rain? = null,
    val clouds: Clouds,
    val dt: Long,
    val sys: Sys,
    val timezone: Int,
    val name: String,
)
