package eu.codlab.openweathermap.models.api2

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class Forecast(
    @SerialName("dt")
    val timestamp: Long,
    val main: MainInformationForecast,
    @SerialName("weather")
    val weathers: List<WeatherCondition>,
    val clouds: Clouds,
    val wind: Wind,
    val visibility: Long,
    val snow: Snow? = null,
    /**
     * Probability Of Precipitation from 0 to 1
     */
    val pop: Float,
    val rain: Rain? = null,
    val sys: SysForecast,
    @SerialName("dt_text")
    val timestampString: String? = null,
    val country: String? = null,
    val population: Long? = null,
    val timezone: Long? = null,
    val sunrise: Long? = null,
    val sunset: Long? = null
)
