package eu.codlab.openweathermap.calls

import eu.codlab.openweathermap.models.api2.ForecastAnswer
import eu.codlab.openweathermap.models.api2.WeatherData
import eu.codlab.openweathermap.rest.RestOptions
import io.ktor.client.request.get
import kotlinx.serialization.KSerializer

class RestApiPublic(options: RestOptions) : InternalRestClient(options) {
    private val url: String = "https://api.openweathermap.org/data/2.5"

    private suspend fun <O> call(
        action: String,
        params: Map<String, String>,
        deserializer: KSerializer<O>
    ): O? {
        val query = params.entries.joinToString("&") { "${it.key}=${it.value}" }
        val mandatory = "units=${options.units}&APPID=${options.apiKey}"

        val response = client.get("$url/$action?$mandatory&$query")

        return map(response, deserializer)
    }

    suspend fun weather(
        params: Map<String, String>
    ) = call("weather", params, WeatherData.serializer())

    suspend fun forecast4days(
        params: Map<String, String>
    ) = call("forecast", params, ForecastAnswer.serializer())?.list
}
