package eu.codlab.openweathermap.utils

import eu.codlab.http.Configuration
import eu.codlab.http.createClient
import io.ktor.client.request.header
import io.ktor.http.HttpHeaders

object ClientProvider {
    fun createClient(timeout: Long) = createClient(
        configuration = Configuration(
            connectTimeoutMillis = timeout,
            socketTimeoutMillis = timeout,
            requestTimeoutMillis = timeout,
            enableLogs = true
        ),
        onAuth = {

        },
        onRequest = {
            it.header(HttpHeaders.ContentType, "application/json")
            it.header(HttpHeaders.UserAgent, "Open Weather Map Kotlin API")
        }
    )
}
