package eu.codlab.openweathermap.models.api2

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class Coord(
    val lon: Double,
    val lat: Double
)

@Serializable
data class WeatherCondition(
    val id: Int,
    val main: String,
    val description: String,
    val icon: String
)

@Serializable
data class MainInformation(
    val temp: Float,
    val feels_like: Float,
    val pressure: Int,
    val humidity: Int,
    val temp_min: Float,
    val temp_max: Float
)

@Serializable
data class Wind(
    val speed: Float,
    val deg: Int,
    val gust: Int? = null
)

@Serializable
data class Clouds(
    val all: Int
)

@Serializable
data class Rain(
    @SerialName("1h")
    val h1: Float,
    @SerialName("2h")
    val h3: Float
)

@Serializable
data class Sys(
    val type: Int,
    val id: Int,
    val message: String? = null,
    val country: String,
    val sunrise: Long,
    val sunset: Long
)

@Serializable
data class WeatherData(
    val coord: Coord,
    val weather: List<WeatherCondition>,
    val base: String,
    val main: MainInformation,
    val wind: Wind,
    val rain: Rain? = null,
    val clouds: Clouds,
    val dt: Long,
    val sys: Sys,
    val timezone: Int,
    val name: String,
)
