package eu.codlab.openstf

import kotlinx.serialization.Serializable

@Serializable
data class UserInfo(
    val success: Boolean,
    val user: UserInfoData,
)

@Serializable
data class UserInfoData(
    val adbKeys: List<AdbKey>,
    val createdAt: String,
    val email: String,
    val group: String,
    val ip: String,
    val lastLoggedInAt: String,
    val name: String,
    val privilege: String
)

@Serializable
data class AdbKey(
    val fingerprint: String,
    val title: String,
)