package eu.codlab.openstf

import io.ktor.client.HttpClient
import io.ktor.client.request.delete
import io.ktor.client.request.get
import io.ktor.client.request.setBody
import kotlinx.serialization.Serializable
import kotlin.time.Duration
import kotlin.time.Duration.Companion.minutes

class User(private val client: HttpClient, private val prefix: String) {
    suspend fun current() = client.get("${prefix}/api/v1/user").bodyOrException<UserInfo>()
        .user

    suspend fun controlled() =
        client.get("${prefix}/api/v1/user/devices").bodyOrException<AnswerDevices>().devices

    suspend fun revoke(serial: String) =
        client.delete("${prefix}/api/v1/user/devices/$serial")
            .bodyOrException<AnswerSuccess>().success

    suspend fun remoteConnect(serial: String) =
        client.multiplatformPost("${prefix}/api/v1/user/devices/${serial}/remoteConnect")
            .bodyOrException<AnswerRemoteConnect>().remoteConnectUrl
}

@Serializable
data class AnswerSuccess(
    val success: Boolean,
    val description: String
)



@Serializable
data class AnswerRemoteConnect(
    val success: Boolean = false,
    val description: String = "",
    val remoteConnectUrl: String? = null
)