package eu.codlab.openstf

import io.ktor.client.HttpClient
import io.ktor.client.request.delete
import io.ktor.client.request.get
import io.ktor.client.request.setBody
import kotlin.time.Duration
import kotlin.time.Duration.Companion.minutes

class Device internal constructor(
    private val serial: String,
    private val client: HttpClient,
    private val prefix: String,
    _last: DeviceInfo
) {

    var localInfo: DeviceInfo = _last
        internal set

    suspend fun current(): DeviceInfo {
        val info =
            client.get("$prefix/api/v1/devices/$serial").bodyOrException<AnswerDevice>().device

        localInfo = info
        return info
    }

    suspend fun control(timeout: Duration = 10.minutes) =
        client.multiplatformPost("${prefix}/api/v1/user/devices") {
            setBody(DeviceSerial(serial, timeout.inWholeMilliseconds))
        }.bodyOrException<AnswerSuccess>().success

    suspend fun revoke() =
        client.delete("${prefix}/api/v1/user/devices/$serial")
            .bodyOrException<AnswerSuccess>().success

    suspend fun remoteConnect(): String? {
        val body = client.multiplatformPost("${prefix}/api/v1/user/devices/${serial}/remoteConnect")
            .bodyOrException<AnswerRemoteConnect>()

        println(body)

        return body.remoteConnectUrl
    }

}
