package eu.codlab.openstf

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class AnswerDevices(
    val success: Boolean = false,
    val description: String = "",
    val devices: List<DeviceInfo>
)

@Serializable
data class AnswerDevice(
    val success: Boolean = false,
    val description: String = "",
    val device: DeviceInfo
)

@Serializable
data class DeviceInfo(
    val abi: String, //TODO enum
    val airplaneMode: Boolean,
    val battery: Battery? = null,
    val channel: String,
    val cpuPlatform: String,
    val createdAt: String,
    val display: Display,
    val group: Group,
    @SerialName("logs_enabled")
    val logsEnabled: Boolean,
    val manufacturer: String,
    val marketName: String,
    val model: String,
    val network: Network,
    val openGLESVersion: String,
    val operator: String? = null,
    val owner: Owner? = null,
    val phone: Phone,
    val platform: String,
    val presenceChangedAt: String,
    val present: Boolean,
    val product: String,
    val provider: Provider,
    val ready: Boolean,
    val remoteConnect: Boolean,
    val remoteConnectUrl: String? = null,
    // reverseForwards,
    val sdk: String,
    val serial: String,
    val status: Int,
    val statusChangedAt: String,
    // usage,
    val usageChangedAt: String? = null,
    val version: String,
    val using: Boolean
)

@Serializable
data class Battery(
    val health: String,
    val level: Int,
    val scale: Int,
    val source: String,
    val status: String,
    val temp: Double,
    val voltage: Double
)

@Serializable
data class Display(
    val density: Double,
    val fps: Double,
    val height: Int,
    val id: Int,
    val rotation: Int,
    val secure: Boolean,
    val size: Double,
    val url: String,
    val width: Int,
    val xdpi: Double,
    val ydpi: Double
)

@Serializable
data class Group(
    @SerialName("class")
    val klass: String,
    val id: String,
    val lifeTime: LifeTime,
    val lock: Boolean,
    val name: String,
    val origin: String,
    val originName: String,
    val owner: Owner,
    val repetitions: Int
)

@Serializable
data class LifeTime(
    val start: String,
    val stop: String
)

@Serializable
data class Owner(
    val email: String,
    val name: String
)

@Serializable
data class Network(
    val connected: Boolean,
    val failover: Boolean,
    val roaming: Boolean,
    val subtype: String,
    val type: String
)

@Serializable
data class Phone(
    val phone: String? = null,
    val iccid: String? = null,
    val imei: String? = null,
    val imsi: String? = null,
    val network: String? = null,
    val phoneNumber: String? = null,
)

@Serializable
data class Provider(
    val channel: String,
    val name: String
)
