package eu.codlab.openstf

import eu.codlab.http.createClient
import io.ktor.client.HttpClient
import io.ktor.client.call.body
import io.ktor.client.request.HttpRequestBuilder
import io.ktor.client.request.accept
import io.ktor.client.request.get
import io.ktor.client.request.post
import io.ktor.client.statement.HttpResponse
import io.ktor.http.ContentType
import io.ktor.http.contentType
import io.ktor.http.isSuccess

class OpenSTF(
    private val scheme: String,
    private val host: String,
    private val accessToken: String
) {
    private val prefix = "$scheme://$host"
    private val deviceMap: HashMap<String, Device> = HashMap()

    private val client = createClient {
        it.headers.append("Authorization", "Bearer $accessToken")
    }

    suspend fun devices(): List<Device> {
        val result = client.get("$prefix/api/v1/devices").bodyOrException<AnswerDevices>().devices

        return result.map {
            if (deviceMap.containsKey(it.serial)) {
                deviceMap[it.serial]?.localInfo = it
            } else {
                deviceMap[it.serial] = Device(it.serial, client, prefix, it)
            }

            return@map deviceMap[it.serial]!!
        }
    }

    fun user() = User(client, "$scheme://$host")
}

suspend inline fun <reified T> HttpResponse.bodyOrException(): T {
    if (!this.status.isSuccess()) {
        throw IllegalStateException("Invalid answer")
    }

    return this.body()
}

suspend inline fun HttpClient.multiplatformPost(
    path: String,
    block: HttpRequestBuilder.() -> Unit = {}
): HttpResponse {
    return post(path) {
        contentType(ContentType.Application.Json)
        accept(ContentType.Application.Json)

        block()
    }
}