package eu.codlab.http

import io.ktor.client.plugins.cookies.CookiesStorage
import kotlinx.serialization.json.Json

data class Configuration(
    val json: Json = Json {
        encodeDefaults = true
        ignoreUnknownKeys = true
        prettyPrint = true
    },
    val enableLogs: Boolean = false,
    val enableSocket: Boolean = false,

    val connectTimeoutMillis: Long = 12000,
    val requestTimeoutMillis: Long = 12000,
    val socketTimeoutMillis: Long = 12000,

    val followRedirects: Boolean = true,

    val installCookies: Boolean = false,
    val cookieStorage: CookiesStorage? = null,

    val proxyConfiguration: ProxyConfiguration? = null,
)
